/**
*    Ripple.cpp
*    
*    Extention of Routine to display a ripple effect using the sin function.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#include "Arduino.h"
#include "Ripple.h"

Ripple::Ripple()
{
	runTime = 0;
}

void Ripple::update(unsigned long dt)
{
	runTime += 1.0*dt/1000000;

	for(byte x = 0 ; x < CUBE_SIZE ; x++)
	{
		for(byte y = 0 ; y < CUBE_SIZE ; y++)
		{
			for(byte z = 0 ; z < CUBE_SIZE ; z++)
			{
				cubeModel[x][y][z] = false;	
			}
		}
	}	
	for(byte x = 0 ; x < CUBE_SIZE ; x++)
	{
		for(byte y = 0 ; y < CUBE_SIZE ; y++)
		{
			float cDist = sqrt(((x-3)*(x-3))+((y-3)*(y-3)));
			
			float zfloat = 3*sin(.75*cDist + 5*runTime) + 3;
		
			int z = int(zfloat + .5);
		
			cubeModel[x][y][z] = true;
		}		
	}		
}